"ALKINDI".BOOK_BI_PRODUCT
   BEFORE INSERT ON BOOK
FOR EACH ROW

DECLARE
BEGIN
   INSERT INTO PRODUCT (
      PRODUCT_ID,
      PRODUCT_TYPE_ID
   ) VALUES (
      :NEW.PRODUCT_ID,
      :NEW.PRODUCT_TYPE_ID
   );
END BOOK_BI_PRODUCT;



"ALKINDI".MOVIE_BI_PRODUCT
   BEFORE INSERT ON MOVIE
FOR EACH ROW

DECLARE
BEGIN
   INSERT INTO PRODUCT (
      PRODUCT_ID,
      PRODUCT_TYPE_ID
   ) VALUES (
      :NEW.PRODUCT_ID,
      :NEW.PRODUCT_TYPE_ID
   );
END MOVIE_BI_PRODUCT;



"ALKINDI".MUSIC_BI_PRODUCT
   BEFORE INSERT ON MUSIC
FOR EACH ROW

DECLARE
BEGIN
   INSERT INTO MUSIC (
      PRODUCT_ID,
      PRODUCT_TYPE_ID
   ) VALUES (
      :NEW.PRODUCT_ID,
      :NEW.PRODUCT_TYPE_ID
   );
END MUSIC_BI_PRODUCT;



"ALKINDI".REL_USER_CLUSTER_AI_USER_STAT
   AFTER INSERT ON REL_USER_CLUSTER
FOR EACH ROW

DECLARE
BEGIN
   INSERT INTO USER_STAT (
      USER_ID
   ) VALUES (
      :NEW.USER_ID
   );
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
   null;
END REL_USER_CLUSTER_AI_USER_STAT;



USER_CLUSTER_AI_PROD_UC_STAT
   AFTER INSERT ON USER_CLUSTER
FOR EACH ROW
DECLARE
BEGIN
   INSERT INTO PROD_UC_STAT (
      PRODUCT_ID,
      PRODUCT_TYPE_ID,
      USER_CLUSTER_ID,
      USER_CLUSTER_INDEX,
      PRODUCT_CLUSTER_ID
   )
   SELECT P.PRODUCT_ID,
          P.PRODUCT_TYPE_ID,
          :NEW.USER_CLUSTER_ID,
          :NEW.USER_CLUSTER_INDEX,
          :NEW.PRODUCT_CLUSTER_ID
   FROM   SELECTABLE_PROD_CLUSTER R, -- was   FROM   REL_PRODUCT_CLUSTER R,
          PRODUCT P
   WHERE  R.PRODUCT_CLUSTER_ID = :NEW.PRODUCT_CLUSTER_ID AND
          P.PRODUCT_ID = R.PRODUCT_ID;
END USER_CLUSTER_AI_PROD_UC_STAT;



"ALKINDI".USER_CLUSTER_AI_UC_STAT
   AFTER INSERT ON USER_CLUSTER
FOR EACH ROW

DECLARE
BEGIN
   INSERT INTO UC_STAT (
      USER_CLUSTER_ID,
      USER_CLUSTER_INDEX,
      PRODUCT_CLUSTER_ID
   ) VALUES (
      :NEW.USER_CLUSTER_ID,
      :NEW.USER_CLUSTER_INDEX,
      :NEW.PRODUCT_CLUSTER_ID
   );
END USER_CLUSTER_AI_UC_STAT;



"ALKINDI".USER_CLUST_AI_UC_SUBGROUP_STAT
   AFTER INSERT ON USER_CLUSTER
FOR EACH ROW
DECLARE
   v_SUBGROUPS_PER_UC NUMBER := 8;
BEGIN
   for i in 1..v_SUBGROUPS_PER_UC loop
      INSERT INTO UC_SUBGROUP_STAT (
         PRODUCT_CLUSTER_ID,
         USER_CLUSTER_ID,
         USER_CLUSTER_SUBGROUP_INDEX
      ) VALUES (
         :NEW.PRODUCT_CLUSTER_ID,
         :NEW.USER_CLUSTER_ID,
         i-1
      );
   end loop;
END USER_CLUST_AI_UC_SUBGROUP_STAT;



